--------------------------------------------------------------------------------------------
-- Add a changes layer with changes over one generation
--------------------------------------------------------------------

function threeState2two(patt)
   local newPatt = {}
   
   if #patt%2 == 1 then
     
      for i = 1, #patt, 3 do
         if #patt >= i+2 then
            if patt[i+2] == 1 then
               newPatt[#newPatt+1] = patt[i]
               newPatt[#newPatt+1] = patt[i+1]
            end
         end
      end
   else
      newPatt = patt
   end
   
   return (newPatt)
end
--==================================================================

local g = golly()
local gp = require "gplus"

local cellSet = 1
local cellNotSet = 0
local wd = g.getwidth()
local ht = g.getheight()
local yMax = (ht-1)//2
local yMin = yMax-ht+1
local xMax = (wd-1)//2
local xMin = xMax-wd+1

local currindex = g.getlayer()
local changeLayName = "ChangeLay"
local changeLay
local oldLayName = "OldLay"
local oldLay
local gen = g.getgen()

local oldPatt = threeState2two(g.getcells(g.getrect()))
local numLays = g.numlayers()
if ( (numLays > 2) and (g.getname(numLays - 2) == changeLayName) and (g.getname(numLays - 1) == oldLayName)) then
   g.setlayer(numLays-1)
   g.dellayer()
   g.dellayer()
end
g.setlayer(g.numlayers()-1)
changeLay = g.addlayer()
g.setname(changeLayName)
g.setgen(gen)
g.setcolor("border", 196, 196, 196)
oldLay = g.addlayer()
g.setname(oldLayName)
g.setgen(gen)
--g.setcolor("border", 127, 127, 127)
--g.putcells(oldPatt)
local tempLay = g.addlayer()

if (g.numstates() > 2) then
   cellNotSet = 2
   g.setlayer(changeLay)
   g.setcolors({2,255,255,255, 1,255,0,0, 0,255,255,255})  --2 white, 1-red, 0-white
   g.setlayer(oldLay)	
   g.setcolors({2,255,255,255, 1,0,0,0, 0,255,255,255})  -- 2 white, 1-black, 0-white
else
   g.setlayer(changeLay)
   g.setcolors({1,255,0,0})
   g.setlayer(oldLay)	
   g.setcolors({1,0,0,0})
end

g.setlayer(tempLay)
g.putcells(oldPatt,0, 0, 1, 0, 0, 1, "copy")

local newPatt, chgPatt
for st = 1,1 do
   g.setlayer(currindex)
   g.run(1)
   newPatt = threeState2two(g.getcells(g.getrect()))
   g.setlayer(tempLay)
   g.putcells(oldPatt,0, 0, 1, 0, 0, 1, "copy")
   g.putcells(newPatt,0, 0, 1, 0, 0, 1, "xor")
   chgPatt = threeState2two(g.getcells(g.getrect()))
   g.setlayer(changeLay)
   g.putcells(chgPatt,0, 0, 1, 0, 0, 1, "or")
end

local chgs = threeState2two(g.getcells(g.getrect()))
g.show("Chg "..#chgs.." Old "..#oldPatt.." New "..#newPatt)
g.setlayer(oldLay)
g.putcells(oldPatt,0, 0, 1, 0, 0, 1, "copy")
g.putcells(chgs,   0, 0, 1, 0, 0, 1, "not")

g.setlayer(tempLay)
g.dellayer() 
--g.setlayer(oldLay)
--g.dellayer() 
--g.setoption("stacklayers", 1)
g.setlayer(currindex)

------------------------------------------ eof -----------------------------------------